/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.document.FormHandler;

public class Shape {
    protected XShape xShape;
    protected FormHandler oFormHandler;
    private XServiceInfo xServiceInfo;
    protected Point aPoint;
    private Size aSize;
    protected XControlShape xControlShape;
    private XMultiServiceFactory xMSF;
    XShapes xShapes;

    public Shape(FormHandler _oFormHandler, Point _aPoint, Size _aSize) {
        this.aPoint = _aPoint;
        this.aSize = _aSize;
        this.oFormHandler = _oFormHandler;
        this.createShape("com.sun.star.drawing.ControlShape");
    }

    public Shape(FormHandler _oFormHandler, String _sServiceName, Point _aPoint, Size _aSize) {
        try {
            this.aPoint = _aPoint;
            this.aSize = _aSize;
            this.oFormHandler = _oFormHandler;
            Object oShape = this.oFormHandler.xMSF.createInstance(_sServiceName);
            this.xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)oShape);
            this.xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)oShape);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Shape() {
    }

    private void createShape(String sServiceName) {
        try {
            this.xMSF = this.oFormHandler.xMSFDoc;
            Object oShape = this.xMSF.createInstance(sServiceName);
            this.xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
            this.xShape.setPosition(this.aPoint);
            if (this.aSize != null) {
                this.xShape.setSize(this.aSize);
            } else {
                this.xShape.setSize(new Size(1000, 100));
            }
            Helper.setUnoPropertyValue(this.xShape, "AnchorType", TextContentAnchorType.AT_PARAGRAPH);
            this.xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)this.xShape);
            this.xControlShape = (XControlShape)UnoRuntime.queryInterface(XControlShape.class, (Object)this.xShape);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public Size getSize() {
        return this.xShape.getSize();
    }

    public void setSize(Size _aSize) {
        try {
            this.xShape.setSize(_aSize);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(System.err);
        }
    }

    public Point getPosition() {
        return this.xShape.getPosition();
    }

    public void setPosition(Point _aPoint) {
        this.xShape.setPosition(_aPoint);
    }

    public XShape getShape() {
        return this.xShape;
    }

    public XServiceInfo getServiceInfo() {
        return this.xServiceInfo;
    }
}

