/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.JobProperties;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.ReportExecutionException;
import org.libreoffice.report.ReportJobDefinition;
import org.libreoffice.report.pentaho.DefaultNameGenerator;
import org.libreoffice.report.pentaho.PentahoReportEngine;

public class OleProducer {
    private static final Logger LOGGER = Logger.getLogger(OleProducer.class.getName());
    private final InputRepository inputRepository;
    private final OutputRepository outputRepository;
    private final DefaultNameGenerator nameGenerator;
    private final DataSourceFactory dataSourceFactory;
    private final ImageService imageService;
    private final Integer maxRows;

    public OleProducer(InputRepository inputRepository, OutputRepository outputRepository, ImageService imageService, DataSourceFactory dataSourceFactory, Integer maxRows) {
        if (inputRepository == null) {
            throw new NullPointerException();
        }
        if (outputRepository == null) {
            throw new NullPointerException();
        }
        this.inputRepository = inputRepository;
        this.outputRepository = outputRepository;
        this.nameGenerator = new DefaultNameGenerator(outputRepository);
        this.dataSourceFactory = dataSourceFactory;
        this.imageService = imageService;
        this.maxRows = maxRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String produceOle(String source, List masterColumns, List masterValues, List detailColumns) {
        InputRepository subInputRepository = null;
        OutputRepository subOutputRepository = null;
        String output = "";
        try {
            subInputRepository = this.inputRepository.openInputRepository(source);
            output = this.nameGenerator.generateStorageName("Object", null);
            subOutputRepository = this.outputRepository.openOutputRepository(output, "application/vnd.oasis.opendocument.chart");
            try {
                PentahoReportEngine engine = new PentahoReportEngine();
                ReportJobDefinition definition = engine.createJobDefinition();
                JobProperties procParms = definition.getProcessingParameters();
                procParms.setProperty("input.repository", subInputRepository);
                procParms.setProperty("output.repository", subOutputRepository);
                procParms.setProperty("input.name", "content.xml");
                procParms.setProperty("output.name", "content.xml");
                procParms.setProperty("content-type", "application/vnd.oasis.opendocument.chart");
                procParms.setProperty("input.datasource-factory", this.dataSourceFactory);
                procParms.setProperty("input.master-columns", masterColumns);
                procParms.setProperty("input.master-values", masterValues);
                procParms.setProperty("input.detail-columns", detailColumns);
                procParms.setProperty("ImageService", this.imageService);
                procParms.setProperty("MaxRows", this.maxRows);
                engine.createJob(definition).execute();
            }
            catch (ReportExecutionException ex) {
                LOGGER.severe("ReportProcessing failed: " + ex);
            }
            catch (IOException ex) {
                LOGGER.severe("ReportProcessing failed: " + ex);
            }
        }
        catch (IOException ex) {
            LOGGER.severe("ReportProcessing failed: " + ex);
        }
        finally {
            if (subInputRepository != null) {
                subInputRepository.closeInputRepository();
            }
            if (subOutputRepository != null) {
                subOutputRepository.closeOutputRepository();
            }
        }
        return output;
    }
}

